using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp6
{
    internal class Program
    {
        public struct Tacke
        {
            public long x;
            public long y;
            public Tacke(long x, long y)
            {
                this.x = x;
                this.y = y;
            }
        }
        private static long orijentacija(Tacke a, Tacke b, Tacke c)
        {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }
        private static long povrsina(List<Tacke> om)
        {
            long ob = 0;
            int n = om.Count;
            for (int i = 0; i < n; i++)
            {
                int sl = (i + 1) % n;
                ob += om[i].x * om[sl].y;
                ob -= om[i].y * om[sl].x;
            }
            return Math.Abs(ob) / 2;
        }
        private static List<Tacke> omotac(List<Tacke> tacke)
        {
            if (tacke.Count < 3)
                return new List<Tacke>();
            tacke.Sort((a, b) =>
            {
                if (a.x != b.x)
                    return a.x.CompareTo(b.x);
                return a.y.CompareTo(b.y);
            });
            List<Tacke> n = new List<Tacke>();
            foreach (var x in tacke)
            {
                while (n.Count >= 2 && orijentacija(n[n.Count - 2], n[n.Count - 1], x) <= 0)
                    n.RemoveAt(n.Count - 1);
                n.Add(x);
            }
            List<Tacke> v = new List<Tacke>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                var x = tacke[i];
                while (v.Count >= 2 && orijentacija(v[v.Count - 2], v[v.Count - 1], x) <= 0)
                    v.RemoveAt(v.Count - 1);
                v.Add(x);
            }
            v.RemoveAt(v.Count - 1);
            n.RemoveAt(n.Count - 1);
            n.AddRange(v);
            return n;
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<Tacke> tacke = new List<Tacke>();
            for (int i = 0; i < n; i++)
            {
                string[] unos = Console.ReadLine().Split();
                long x = long.Parse(unos[0]);
                long y = long.Parse(unos[1]);
                tacke.Add(new Tacke(x, y));
            }
            List<Tacke> om = omotac(tacke);
            if (om.Count < 3)
            {
                Console.WriteLine(0);
                return;
            }
            long min = long.MaxValue;
            for (int i = 0; i < om.Count; i++)
            {
                List<Tacke> t = new List<Tacke>(tacke);
                t.Remove(om[i]);
                List<Tacke> nom = omotac(t);
                long P = povrsina(nom);
                min = Math.Min(min, P);
            }
            Console.WriteLine(min);
        }
    }
}